<?php

use Elementor\Controls_Manager;
use Elementor\Core\DocumentTypes\PageBase;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Page Header in Elementor Document Settings
 */
add_action( 'elementor/element/wp-page/document_settings/after_section_end',
	'blackdsn_document_settings_page_footer_animate' );
add_action( 'elementor/element/wp-post/document_settings/after_section_end',
	'blackdsn_document_settings_page_footer_animate' );
function blackdsn_document_settings_page_footer_animate( PageBase $page ) {

	$control = new blackdsnControl( $page );

	$page->start_controls_section(
		'page_footer_section_animate',
		array(
			'label'     => esc_html__( 'Footer Animate', 'blackdsn' ),
			'tab'       => Controls_Manager::TAB_SETTINGS,
			'condition' => blackdsn_is_work() ? [] : [ 'show_footer' => '1' ]
		)
	);


	$control->addSwitcher( 'motion_effect_footer' )
	        ->setLabel( esc_html__( 'Motion Effect Footer', 'blackdsn' ) )
	        ->setReturn_value( 'footer-animate' )
	        ->get();

	$control->addSwitcher( 'motion_effect_svg' )
	        ->setLabel( esc_html__( 'Effect Half Circle', 'blackdsn' ) )
	        ->setReturn_value( 'svg-animate' )
	        ->setConditions( 'motion_effect_footer', '!=', '', 'and' )
	        ->get();


	$control->addSelect( 'dsn_footer_bg_ver_svg', [
		''             => __( 'Default', 'blackdsn' ),
		'v-light'      => __( 'Light', 'blackdsn' ),
		'v-light-head' => __( 'Light (Static)', 'blackdsn' ),
		'v-dark'       => __( 'Dark', 'blackdsn' ),
		'v-dark-head'  => __( 'Dark  (Static)', 'blackdsn' ),
	] )
	        ->setDefault( '' )
	        ->setLabelBlock()
	        ->setLabel( __( 'Version Background Section', 'blackdsn' ) )
	        ->setDescription( __( 'If you choose the wallpaper version, it is best to choose the type of background section',
		        'blackdsn' ) )
	        ->setConditions( 'motion_effect_footer', '!=', '', 'and' )
	        ->setConditions( 'motion_effect_svg', '!=', '', 'and' )
	        ->get();


	$control->addIconColor( 'dsn_footer_bg_svg' )
	        ->setLabelBlock()
	        ->setLabel( __( 'Background Section', 'blackdsn' ) )
	        ->setConditions( 'motion_effect_footer', '!=', '', 'and' )
	        ->setConditions( 'motion_effect_svg', '!=', '', 'and' )
	        ->get();

	$page->add_control(
		'icon_color',
		[
			'label'     => esc_html__( 'Color', 'elementor' ),
			'type'      => Controls_Manager::COLOR,
			'default'   => '',
			'condition' => [
				'dsn_footer_bg_svg'    => '',
				'motion_effect_footer' => 'footer-animate',
				'motion_effect_svg'    => '1',
			],
			'selectors' => [
				'{{WRAPPER}} .dsn-footer svg' => 'fill: {{VALUE}};',
			],

		]
	);

	$page->end_controls_section();

}