<?php

use Elementor\Controls_Manager;
use Elementor\Core\DocumentTypes\PageBase;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}




/**
 * Page Header in Elementor Document Settings
 */
add_action( 'elementor/element/wp-page/document_settings/after_section_end', 'blackdsn_document_settings_page_footer' );
add_action( 'elementor/element/wp-post/document_settings/after_section_end', 'blackdsn_document_settings_page_footer' );
function blackdsn_document_settings_page_footer( PageBase $page ) {

	if ( blackdsn_is_work() )
		return;

	$control = new blackdsnControl( $page );

	$page->start_controls_section(
		'page_footer_section',
		array(
			'label' => esc_html__( 'Footer', 'blackdsn' ),
			'tab'   => Controls_Manager::TAB_SETTINGS,
		)
	);


	$control->addSwitcher( 'show_footer' )
	        ->setLabel( esc_html__( 'Show Footer', 'blackdsn' ) )
	        ->setDefault( '1' )
	        ->get();

	$control->addSelect( 'dsn_footer_layout', [
		''                                  => __( 'Default', 'blackdsn' ),
		'dsn-container'                     => __( 'Wide Page', 'blackdsn' ),
		'container'                         => __( 'Container Page', 'blackdsn' ),
		'dsn-container dsn-right-container' => __( 'Right Container Page', 'blackdsn' ),
		'dsn-container dsn-left-container'  => __( 'Left Container Page', 'blackdsn' ),
	] )
	        ->setDefault( '' )
	        ->setLabel( __( 'Width Layout', 'blackdsn' ) )
	        ->setConditions( 'show_footer', '1' )
	        ->get();

	$control->addSelect( 'dsn_footer_bg_ver', [
		''             => __( 'Default', 'blackdsn' ),
		'v-light'      => __( 'Light', 'blackdsn' ),
		'v-light-head' => __( 'Light (Static)', 'blackdsn' ),
		'v-dark'       => __( 'Dark', 'blackdsn' ),
		'v-dark-head'  => __( 'Dark  (Static)', 'blackdsn' ),
	] )
	        ->setDefault( '' )
	        ->setLabelBlock()
	        ->setLabel( __( 'Version Background Section', 'blackdsn' ) )
	        ->setDescription( __( 'If you choose the wallpaper version, it is best to choose the type of background section',
		        'blackdsn' ) )
	        ->setConditions( 'show_footer', '1' )
	        ->get();

	$control->addSelect( 'dsn_footer_bg', [
		'background-transparent' => __( 'Default', 'blackdsn' ),
		'background-main'        => __( 'Background Main', 'blackdsn' ),
		'background-section'     => __( 'Background Section', 'blackdsn' ),
		'background-theme'       => __( 'Background Theme', 'blackdsn' ),
	] )
	        ->setLabelBlock()
	        ->setDefault( 'background-section' )
	        ->setLabel( __( 'Background Section', 'blackdsn' ) )
	        ->setConditions( 'show_footer', '1' )
	        ->get();

	$control->addSelect( 'type_footer', [
		'default' => esc_html__( "Default", "blackdsn" ),
		'custom'  => esc_html__( "Custom", "blackdsn" )
	] )
	        ->setDefault( 'default' )
	        ->setSeparatorBefore()
	        ->setLabel( esc_html__( "Type Footer", "blackdsn" ) )
	        ->setConditions( 'show_footer', '1' )
	        ->get();


	$control->addSelect2( 'choose_template_footer', blackdsn_get_post_array( 'elementor_library' ) )
	        ->setDefault( 'default' )
	        ->setLabelBlock()
	        ->setLabel( esc_html__( "Choose Template Footer", "blackdsn" ) )
	        ->setConditions( 'show_footer', '===', '1' )
	        ->setConditions( 'type_footer', '===', 'custom', 'and' )
	        ->get();

	$page->end_controls_section();

}