<?php

class DsnSelectControl extends \Elementor\Control_Select {

	public function get_type() {
		return 'dsn_select';
	}

	public function content_template() {
		?>
        <div class="elementor-control-field">
            <# if ( data.label ) {#>
            <label for="<?php $this->print_control_uid(); ?>" class="elementor-control-title">{{{ data.label }}}</label>
            <# } #>
            <div class="elementor-control-input-wrapper elementor-control-unit-5">
                <select id="<?php $this->print_control_uid(); ?>" data-setting="{{ data.name }}">
                    <#
                    let dsnOption = DSN_CONTROLLER[data.target] || {};
                    var printOptions = function( options ) {
                    _.each( options, function( option_title, option_value ) { #>
					<?php // If the option title is array of title & icon. ?>
                    <option value="{{ option_value }}">{{{ option_title?.title || option_title }}}</option>
                    <# } );
                    _.each( dsnOption, function( option_title, option_value ) { #>
					<?php // If the option title is array of title & icon. ?>
                    <option value="{{ option_value }}">{{{ option_title?.title || option_title }}}</option>
                    <# } );
                    };

                    if ( data.groups ) {
                    for ( var groupIndex in data.groups ) {
                    var groupArgs = data.groups[ groupIndex ];
                    if ( groupArgs.options ) { #>
                    <optgroup label="{{ groupArgs.label }}">
                        <# printOptions( groupArgs.options ) #>
                    </optgroup>
                    <# } else if ( _.isString( groupArgs ) ) { #>
                    <option value="{{ groupIndex }}">{{{ groupArgs }}}</option>
                    <# }
                    }
                    } else {
                    printOptions( data.options );
                    }
                    #>
                </select>
            </div>
        </div>
        <# if ( data.description ) { #>
        <div class="elementor-control-field-description">{{{ data.description }}}</div>
        <# } #>
		<?php
	}
}