<?php


use Dsn\Element\BlackdsnRegisterElement;
use Elementor\Elements_Manager;
use Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Blackdsn Widget Extension
 * The main class that initiates and runs the plugin.
 *
 */
class blackdsnWidgetLoader extends BlackdsnRegisterElement {


	use notices;

	/**
	 * Instance
	 *
	 * @access private
	 * @static
	 * @var blackdsnWidgetLoader The single instance of the class.
	 */
	private static $_instance = null;


	/**
	 * Minimum ELEMENTOR Version
	 */
	const MINIMUM_ELEMENTOR_VERSION = '3.0.0';

	/**
	 * Minimum PHP Version
	 */
	const MIN_PHP_VERSION = '7.0';


	/**
	 * Minimum ACF Version
	 */
	const MIN_ACF_VERSION = '5.0';


	/**
	 * Register Block Name
	 */
	const DSN_BLOCK = array(
		'InfoHeader',
		'Title',
		'Heading',
		'Button',
		'Image',
		'sliders'      => 'MediaSlider',
		'JustifyGallery',
		'Compare',
		'posts/slider' => [
			'control' => 'Slider',
			'SliderProject',
			'SliderThreeJS',
		],
		'posts'        => [
			'control' => 'Post',
			'PostGrid',
			'PostSwiper'
		],
		'List',
		'service'      => [
			'control' => 'Service',
			'Grid',
			'Swiper'
		],
		'BGMask',
		'Testimonial',
		'brand'        => [
			'control' => 'Brand',
			'GridBrand',
//			'SwiperBrand'
		],

		'woocommerce' => [
			'Products',
			'Category',
			'Breadcrumb',
		],
		'Logo',
		'Social',
		'MoveImage',
		'Accordion',
		'team'        => [
			'control' => 'Team',
			'GridTeam',
//			'SwiperTeam'
		],

		'navigation' => [
//			'control' => 'Team',
			'Arrow'
		],
		'Map',

		'Skills',
		'AnimateLine',
		'Experience',
		'Tabs',


//		'PricingTable',


//		'MoveSection',
//		'Awards',
//		'Facts',
//
		'GridMasonry',
//		'Feature',


	);


	const DSN_WIDGET = array(
//		'Social',
//        'Logo',
//		'ScrollTop',
	);


	/**
	 * Instance
	 * Ensures only one instance of the class is loaded or can be loaded.
	 *
	 * @access public
	 * @static
	 *
	 * @return blackdsnWidgetLoader An instance of the class.
	 */
	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;

	}


	/**
	 * Initializing the blackdsnWidgetLoader class.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function __construct() {

		require_once __DIR__ . '/widgets/control/BlackdsnControl.php';
		add_action( 'widget_loader', [ $this, 'register_widget' ] );
	}


	function preload_style( $tag, $handle, $src ) {
		// the handles of the enqueued scripts we want to async
		$async_scripts = array( 'blackdsn-fonts' );


		if ( in_array( $handle, $async_scripts ) ) {
			return sprintf( '<link id="blackdsn-fonts" rel="preload" href="%1$s" as="style" onload="this.onload=null;this.rel=\'stylesheet\'"><noscript><link href="%1$s" rel="stylesheet"></noscript>',
				$src );
		}

		return $tag;
	}



	/**
	 *
	 */

	/**
	 * Initialize the Widget
	 * Retrieve the current widget initial configuration.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function register_widget() {


		if ( ! $this->elementorLoaded() || ! $this->PHPVer() )
			return;

		add_action( 'elementor/controls/register', function ( $controls_manager ) {
			require_once( __DIR__ . '/controls/DsnSelectControl.php' );

			$controls_manager->register( new \DsnSelectControl() );
		} );


		/**
		 * registering new Elementor widgets Category
		 */
		add_action( 'elementor/elements/categories_registered', function ( Elements_Manager $elements_manager ) {

			$elements_manager->add_category(
				'blackdsn_cat',
				[
					'title' => esc_html__( 'Blackdsn Widget(Design Blackdsn)', 'blackdsn' ),
					'icon'  => 'fa fa-plug',
				]
			);

		} );


		/**
		 * registering new Elementor widgets
		 */

//		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
		add_action( 'elementor/widgets/register', [ $this, 'register_widgets' ] );


		$this->registerWidgetSection();
		$this->registerRenderSection();

		add_action( 'elementor/elements/elements_registered', [ $this, 'register_elements' ] );


	}


	/**
	 * Register oEmbed Widget.
	 *
	 * Include widget file and register widget class.
	 *
	 *
	 *
	 * @return void
	 * @since 1.0.0
	 */
	public function register_widgets( $widgets_manager ) {

		require_once __DIR__ . '/widgets/control/BlackdsnSlider.php';
		require_once __DIR__ . '/widgets/control/BlackdsnLayout.php';

		/**
		 * Control Widget
		 */


		foreach ( self::DSN_BLOCK as $key => $block ):


			if ( $block ) {
				if ( is_array( $block ) ) {
					foreach ( $block as $key2 => $instance ) {
						if ( $key2 === 'control' ) {
							require_once __DIR__ . '/widgets/' . $key . '/' . $instance . 'Control.php';
							continue;
						}

						$this->getInstanceWidget( $key, $instance, $widgets_manager );
					}
				} else {

					$this->getInstanceWidget( $key, $block, $widgets_manager );
				}


			}

		endforeach;


	}

	/**
	 * check version < 3.5.0
	 * @return bool|int
	 */
	private function CheckVersionElement(){
		return version_compare( ELEMENTOR_VERSION, "3.5.0", '<' );
	}


	/**
	 * @param $key
	 * @param $instance
	 *
	 */
	private function getInstanceWidget( $key, $instance, $widgets_manager ) {

		$instance = 'Blackdsn' . $instance;
		if ( is_string( $key ) ) {
			$key .= '/';
		} else {
			$key = '';
		}

		require_once __DIR__ . '/widgets/' . $key . $instance . '.php';

		if ( $this->CheckVersionElement() )
			Plugin::instance()->widgets_manager->register_widget_type( new $instance() );
		else
			$widgets_manager->register( new $instance() );
	}


	/**
	 * Register Custom Elements
	 *
	 * @access public
	 *
	 * @return void
	 */

	public function register_elements() {
		require_once 'widgets/control/blackdsnColumn.php';
		require_once 'widgets/control/blackdsnSection.php';
		Plugin::instance()->elements_manager->register_element_type( new blackdsnColumn() );
		Plugin::instance()->elements_manager->register_element_type( new blackdsnSection() );
	}


}

blackdsnWidgetLoader::instance();
