<?php

/**
 *
 *
 * ==============================================
 *
 *          Customize Register
 *
 * ===============================================
 *
 * The 'customize_register' action hook is used to customize and manipulate the Theme
 * Customization admin screen introduced .
 *
 */


add_action( 'wp_head', function () {
	$width_logo       = get_theme_mod( 'width_number', 0 );
	$width_logo       = ( (int) $width_logo === 0 ) ? 'auto' : $width_logo . 'px';
	$height_logo      = get_theme_mod( 'height_number', 0 );
	$height_logo      = ( (int) $height_logo === 0 ) ? 'auto' : $height_logo . 'px';
	$logo_size_number = get_theme_mod( 'logo_size_number', 30 );

	printf( '<style>#site_menu_header .main-logo img{width:%s !important;height: %s !important}.main-logo h4{font-size:%s}</style>',
		$width_logo, $height_logo, $logo_size_number . 'px' );
	printf( '<style id="blackdsn_code_css">%s</style>', get_theme_mod( 'css_head_code' ) );
	printf( '<script id="blackdsn_code_js_head">%s</script>', get_theme_mod( 'js_head_code' ) );


} );

if ( class_exists( 'Kirki' ) ):
	/**
	 * Update Kirki Config
	 */
	$dsn_customize = 'dsn_customize';
	Kirki::add_config( $dsn_customize, array(
		'capability'  => 'edit_theme_options',
		'option_type' => 'theme_mod'

	) );

	function blackdsn_custom_Label( $section, $text = '', $label = '', $active_callback = true ) {
		$out = '';
		if ( $text ) {
			$out = '<div style="padding: 10px;background-color: #008ec2;color: #fff;border-radius: 3px;text-align: center;font-size: 14px;text-transform: capitalize;">' . $text . '</div><p>' . $label . '</p>';
		}

		Kirki::add_field( 'dsn_customize', [
			'type'            => 'custom',
			'settings'        => 'custom_setting_' . sanitize_title( $text ) . sanitize_title( $label ),
			'section'         => $section,
			'default'         => $out,
			'active_callback' => $active_callback
		] );
	}


	$dsn_panel = 'dsn_panel';
	Kirki::add_panel( $dsn_panel, array(
		'title'       => esc_html__( 'blackdsn Customize Option', 'blackdsn' ),
		'description' => esc_html__( 'My Options Theme', 'blackdsn' ),
		'icon'        => 'dashicons-buddicons-topics',

	) );


	/**
	 * Header Image
	 */
	$dsn_section = 'header_image';
	blackdsn_resources_customize( 'header_image', array(
		'dsn_panel'     => $dsn_panel,
		'dsn_customize' => $dsn_customize,
		'dsn_section'   => $dsn_section
	) );


	/**
	 * Theme options
	 */

	$dsn_section = 'theme_options';
	blackdsn_resources_customize( 'theme_options', array(
		'dsn_panel'     => $dsn_panel,
		'dsn_customize' => $dsn_customize,
		'dsn_section'   => $dsn_section,
	) );


	/**
	 * General options
	 */

	$dsn_section = 'general_options';
	blackdsn_resources_customize( 'general_options', array(
		'dsn_panel'     => $dsn_panel,
		'dsn_customize' => $dsn_customize,
		'dsn_section'   => $dsn_section,
	) );


	/**
	 * Map_settings
	 */
	$dsn_section = 'map_setting';
	blackdsn_resources_customize( 'map_setting', array(
		'dsn_panel'     => $dsn_panel,
		'dsn_customize' => $dsn_customize,
		'dsn_section'   => $dsn_section
	) );


	/**
	 * footer_settings
	 */
	$dsn_section = 'footer_setting';
	blackdsn_resources_customize( 'footer_setting', array(
		'dsn_panel'     => $dsn_panel,
		'dsn_customize' => $dsn_customize,
		'dsn_section'   => $dsn_section
	) );


    /**
     * social_settings
     */
    $dsn_section = 'social_settings';
    blackdsn_resources_customize( 'social_settings', array(
        'dsn_panel'     => $dsn_panel,
        'dsn_customize' => $dsn_customize,
        'dsn_section'   => $dsn_section
    ) );

    /**
     * options_page
     */
    $dsn_section = 'options_page';
    blackdsn_resources_customize( 'page_options', array(
        'dsn_panel'     => $dsn_panel,
        'dsn_customize' => $dsn_customize,
        'dsn_section'   => $dsn_section
    ) );


    return;





	/**
	 * Fonts_setting
	 */
	$dsn_section = 'section_fonts';
	blackdsn_resources_customize( 'typography', array(
		'dsn_panel'     => $dsn_panel,
		'dsn_customize' => $dsn_customize,
		'dsn_section'   => $dsn_section
	) );



endif;

add_action( 'blackdsn_add_code_header', function () {
	printf( '<div class="blackdsn_acht">%s</div>', get_theme_mod( 'html_head_code' ) );
} );

add_action( 'wp_footer', function () {
	printf( '<script>%s</script>', get_theme_mod( 'js_footer_code' ) );
}, 100 );