<?php


Kirki::add_section( $dsn_section , array(
    'panel' => $dsn_panel ,
    'title' => esc_html__( 'Typography' , 'grida' ),
    'icon'=>'dashicons-color-picker'

) );

Kirki::add_field( $dsn_customize , [
    'type'        => 'toggle' ,
    'settings'    => 'event_typography' ,
    'label'       => esc_html__( 'Event Typograph' , 'grida' ) ,
    'section'     => $dsn_section ,
    'default'     => false ,
] );




Kirki::add_field( $dsn_customize , array(
    'type'     => 'typography' ,
    'settings' => 'body_font' ,
    'section'  => $dsn_section ,
    'label'    => esc_html__( 'Primary Font' , 'grida' ) ,

    'choices' => [
        'fonts' => [
            'standard' => [ 'sans-serif' ] ,

        ] ,
    ] ,

    'default'         => array(
        'font-family' => 'Roboto' ,
        'font-size'   => '16px' ,
        'line-height' => '1.4' ,
        'font-weight' => '400' ,
    ) ,
    'output'          => array(
        array(
            'element' => 'body' ,
        ) ,
    ) ,
    'active_callback' => [
        [
            'setting'  => 'event_typography' ,
            'operator' => '==' ,
            'value'    => true ,
        ]
    ] ,

) );


Kirki::add_field( $dsn_customize , array(
    'type'     => 'typography' ,
    'settings' => 'heading_font' ,
    'section'  => $dsn_section ,
    'label'    => esc_html__( 'Heading Font' , 'grida' ) ,

    'choices' => [
        'fonts' => [
            'standard' => [ 'sans-serif' ] ,
        ] ,
    ] ,

    'default'         => array(
        'font-family' => 'Poppins' ,
        'font-weight' => '600' ,

    ) ,
    'output'          => array(
        array(
            'element' => 'h1 , h2 , h3 , h4 , h5 ,.title-block , .title, .editor-post-title__input' ,
        ) ,
    ) ,
    'active_callback' => [
        [
            'setting'  => 'event_typography' ,
            'operator' => '==' ,
            'value'    => true ,
        ]
    ] ,

) );