<?php
Kirki::add_section( $dsn_section, array(
	'panel' => $dsn_panel,
	'title' => esc_html__( 'Social Settings', 'blackdsn' ),
	'icon'  => 'dashicons-networking'

) );


Kirki::add_field( $dsn_customize, [
	'type'     => 'toggle',
	'settings' => 'effect_dsn_socials',
	'label'    => esc_html__( 'Effect Cursor', 'blackdsn' ),
	'section'  => $dsn_section,
	'default'  => "1",
] );

$active_callback = [
	[
		'setting'  => 'effect_dsn_socials',
		'operator' => '==',
		'value'    => '1',
	]
];


Kirki::add_field( $dsn_customize, [
	'type'      => 'repeater',
	'label'     => esc_html__( 'All Social', 'blackdsn' ),
	'section'   => $dsn_section,
	'transport' => 'postMessage',

	'row_label'       => [
		'type'  => 'field',
		'value' => esc_html__( 'Social Settings', 'blackdsn' ),
		'field' => 'name',
	],
	'button_label'    => esc_html__( '"Add new" (Social) ', 'blackdsn' ),
	'settings'        => 'dsn_socials',
	'fields'          => [

		'init_name' => [
			'type'      => 'text',
			'label'     => esc_html__( 'initial Social Name', 'blackdsn' ),
			'default'   => '',
			'transport' => 'postMessage',

		],
		'icon'      => [
			'type'        => 'text',
			'label'       => esc_html__( 'Icon Social', 'blackdsn' ),
			'description' => __( 'You can control this icons from <a href="https://fontawesome.com/icons?d=gallery&m=free" target="_blank" >This Page </a> copy into class like fab fa-500px', 'blackdsn' ),
			'default'     => '',
			'transport'   => 'postMessage',


		],
		'link'      => [
			'type'    => 'textarea',
			'label'   => esc_html__( 'URL', 'blackdsn' ),
			'default' => '',

		]
	],
	'default'         => blackdsn_default_social(),
	'active_callback' => $active_callback,
] );
