<?php

Kirki::add_section( $dsn_section, array(
	'panel' => $dsn_panel,
	'title' => esc_html__( 'Smooth Scrollbar', 'blackdsn' ),
	'icon'  => 'dashicons-image-flip-horizontal',

) );


Kirki::add_field( $dsn_customize, [
	'type'        => 'toggle',
	'settings'    => 'event_smooth_scrolling',
	'label'       => esc_html__( 'Event Smooth Scrolling', 'blackdsn' ),
	'description' => esc_html__( 'Distance. Use smaller value for shorter scroll and greater value for longer scroll', 'blackdsn' ),
	'section'     => $dsn_section,
	'default'     => false
] );

$active_callback = [
	[
		'setting'  => 'event_smooth_scrolling',
		'operator' => '==',
		'value'    => '1',
	]
];

Kirki::add_field( $dsn_customize, [
	'type'            => 'number',
	'settings'        => 'event_smooth_scrolling_damping',
	'label'           => esc_html__( 'Damping', 'blackdsn' ),
	'description'     => esc_html__( 'Momentum reduction damping factor, a float value between (0.01, 1). The lower the value is, the more smooth the scrolling will be (also the more paint frames).', 'blackdsn' ),
	'section'         => $dsn_section,
	'default'         => 0.06,
	'choices'         => [
		'min'  => 0.01,
		'max'  => 1,
		'step' => 0.01,
	],
	'active_callback' => $active_callback,
] );


Kirki::add_field( $dsn_customize, [
	'type'            => 'toggle',
	'settings'        => 'event_smooth_scrolling_style',
	'label'           => esc_html__( 'Custom Style', 'blackdsn' ),
	'section'         => $dsn_section,
	'active_callback' => $active_callback,

	'default' => false
] );


$active_callback[] = [
	'setting'  => 'event_smooth_scrolling_style',
	'operator' => '==',
	'value'    => '1',
];


Kirki::add_field( $dsn_customize, [
	'type'     => 'color',
	'settings' => 'color_setting_scroll',
	'label'    => __( 'Color Scrollbar ', 'blackdsn' ),
	'section'  => $dsn_section,

	'default'         => '#424242',
	'choices'         => [
		'alpha' => true,
	],
	'transport'       => 'postMessage',
	'js_vars'         => [
		[
			'element'  => '.dsn-effect-scroll:not(.dsn-mobile) #dsn-scrollbar .scrollbar-track .scrollbar-thumb, .sidebar-single .scrollbar-track .scrollbar-thumb, .dsn-work-scrollbar .scrollbar-track .scrollbar-thumb',
			'property' => 'background',
			'function' => 'css',

		]
	],
	'output'          => array(
		array(
			'element'  => '.dsn-effect-scroll:not(.dsn-mobile) #dsn-scrollbar .scrollbar-track .scrollbar-thumb, .sidebar-single .scrollbar-track .scrollbar-thumb, .dsn-work-scrollbar .scrollbar-track .scrollbar-thumb',
			'property' => 'background'
		),
	),
	'active_callback' => $active_callback,
] );
Kirki::add_field( $dsn_customize, [
	'type'        => 'select',
	'settings'    => 'select_setting',
	'label'       => esc_html__( 'This is the label', 'kirki' ),
	'section'     => $dsn_section,
	'default'     => 'unset',
	'placeholder' => esc_html__( 'Select an option...', 'kirki' ),
	'priority'    => 10,
	'multiple'    => false,
	'choices'     => [
		'unset'       => esc_html__( 'Normal', 'blackdsn' ),
		'multiply'    => 'Multiply',
		'screen'      => 'Screen',
		'overlay'     => 'Overlay',
		'darken'      => 'Darken',
		'lighten'     => 'Lighten',
		'color-dodge' => 'Color Dodge',
		'saturation'  => 'Saturation',
		'color'       => 'Color',
		'difference'  => 'Difference',
		'exclusion'   => 'Exclusion',
		'hue'         => 'Hue',
		'luminosity'  => 'Luminosity',
	],
	'js_vars'         => [
		[
			'element'  => '.dsn-effect-scroll:not(.dsn-mobile) #dsn-scrollbar .scrollbar-track, .sidebar-single .scrollbar-track, .dsn-work-scrollbar .scrollbar-track',
			'property' => 'mix-blend-mode',
			'function' => 'css',

		]
	],
	'transport'       => 'postMessage',
	'output'          => array(
		array(
			'element'  => '.dsn-effect-scroll:not(.dsn-mobile) #dsn-scrollbar .scrollbar-track, .sidebar-single .scrollbar-track, .dsn-work-scrollbar .scrollbar-track',
			'property' => 'mix-blend-mode'
		),
	),
	'active_callback' => $active_callback,
] );

Kirki::add_field( $dsn_customize, [
	'type'     => 'Text',
	'settings' => 'width_setting_scroll',
	'label'    => __( 'Width Scrollbar ', 'blackdsn' ),
	'section'  => $dsn_section,

	'default' => '5px',

	'transport'       => 'postMessage',
	'js_vars'         => [
		[
			'element'  => '.dsn-effect-scroll:not(.dsn-mobile) #dsn-scrollbar .scrollbar-track .scrollbar-thumb, .sidebar-single .scrollbar-track .scrollbar-thumb, .dsn-work-scrollbar .scrollbar-track .scrollbar-thumb',
			'property' => 'width',
			'function' => 'css',

		]
	],
	'output'          => array(
		array(
			'element'  => '.dsn-effect-scroll:not(.dsn-mobile) #dsn-scrollbar .scrollbar-track .scrollbar-thumb, .sidebar-single .scrollbar-track .scrollbar-thumb, .dsn-work-scrollbar .scrollbar-track .scrollbar-thumb',
			'property' => 'width'
		),
	),
	'active_callback' => $active_callback,

] );

Kirki::add_field( $dsn_customize, [
	'type'     => 'Text',
	'settings' => 'border-radius_setting_scroll',
	'label'    => __( 'Border Radius Scrollbar ', 'blackdsn' ),
	'section'  => $dsn_section,

	'default' => '4px',

	'transport'       => 'postMessage',
	'js_vars'         => [
		[
			'element'  => '.dsn-effect-scroll:not(.dsn-mobile) #dsn-scrollbar .scrollbar-track .scrollbar-thumb, .sidebar-single .scrollbar-track .scrollbar-thumb, .dsn-work-scrollbar .scrollbar-track .scrollbar-thumb',
			'property' => 'border-radius',
			'function' => 'css',

		]
	],
	'output'          => array(
		array(
			'element'  => '.dsn-effect-scroll:not(.dsn-mobile) #dsn-scrollbar .scrollbar-track .scrollbar-thumb, .sidebar-single .scrollbar-track .scrollbar-thumb, .dsn-work-scrollbar .scrollbar-track .scrollbar-thumb',
			'property' => 'border-radius'
		),
	),
	'active_callback' => $active_callback,

] );
