<?php
/**
 *  Home Page
 */

Kirki::add_section( $dsn_section, array(
    'panel' => $dsn_panel,
    'title' => esc_html__( 'Home', 'blackdsn' ),
    'icon'=>'dashicons-admin-home'
) );


blackdsn_custom_Label( $dsn_section, 'Home' );


Kirki::add_field( $dsn_customize, [
    'type'     => 'select',
    'settings' => 'home_show_sidebar',
    'label'    => esc_html__( 'Sidebar', 'blackdsn' ),
    'section'  => $dsn_section,
    'default'  => 'show',
    'multiple' => 1,
    'choices'  => [
        'show' => esc_html__( 'Show', 'blackdsn' ),
        'hide' => esc_html__( 'Hide', 'blackdsn' )
    ]
] );

Kirki::add_field( $dsn_customize, [
    'type'     => 'radio-buttonset',
    'settings' => 'home_style_setting',
    'label'    => esc_html__( 'Background Color', 'blackdsn' ),
    'section'  => $dsn_section,
    'default'  => 'v-dark',
    'priority' => 10,
    'choices'  => [
        'v-dark'  => esc_html__( 'Dark', 'blackdsn' ),
        'v-light' => esc_html__( 'Light', 'blackdsn' ),
    ],
] );


Kirki::add_field( $dsn_customize, [
    'type'              => 'text',
    'settings'          => 'home_custom_title',
    'label'             => esc_html__( 'Title', 'blackdsn' ),
    'section'           => $dsn_section,
    'default'           => 'Our Blog.',
//    'sanitize_callback' => 'blackdsn_sanitize_minimal_decoration',
//    'transport'         => 'postMessage',
    'js_vars'           => [
        [
            'element'  => '#hero_title .title',
            'function' => 'html'
        ]
    ]
] );


Kirki::add_field( $dsn_customize, [
    'type'      => 'text',
    'settings'  => 'home_custom_subtitle',
    'label'     => esc_html__( 'Subtitle', 'blackdsn' ),
    'section'   => $dsn_section,
    'default'   => 'NEWS & IDEAS',
//    'transport' => 'postMessage',
    'js_vars'   => [
        [
            'element'  => '#hero_content .metas span',
            'function' => 'html'
        ]
    ]
] );

//Kirki::add_field( $dsn_customize, [
//    'type'     => 'textarea',
//    'settings' => 'home_custom_desc',
//    'label'    => esc_html__( 'Description', 'blackdsn' ),
//    'section'  => $dsn_section,
//    'default'  => '',
//
//] );
