<?php

Kirki::add_section( $dsn_section, array(
    'panel' => $dsn_panel,
    'title' => esc_html__( '404', 'blackdsn' ),
    'icon'  => 'dashicons-search'

) );

blackdsn_custom_Label( $dsn_section, '404' );

Kirki::add_field( $dsn_customize, [

        'type'     => 'generic',
        'settings' => '404_preview_link',
        'label'    => esc_html__( 'Preview', 'blackdsn' ),
        'section'  => $dsn_section,
        'default' => esc_html__( 'Load Page', 'blackdsn' ),
        'choices' => [
            'element' => 'input',
            'type'    => 'button',
            'class'   => 'button button-secondary',
            'onclick' => 'javascript:wp.customize.previewer.previewUrl.set( "../not-found-" + String( Math.random() ) + "/" );',
        ],
    ]
);


Kirki::add_field( $dsn_customize, [
    'type'     => 'image',
    'settings' => '404_bg_image',
    'label'    => esc_html__( 'Background Image', 'blackdsn' ),
    'section'  => $dsn_section,
    'default'  => trailingslashit( get_template_directory_uri() ) . 'assets/img/404.jpg',


] );

Kirki::add_field( $dsn_customize, [

    'type'     => 'number',
    'settings' => 'overlay_404',
    'label'    => esc_html__( 'Overlay Image', 'kirki' ),
    'section'  => $dsn_section,
    'default'  => 4,
    'choices'  => [
        'min'  => 0,
        'max'  => 10,
        'step' => 1,
    ]
] );