<?php
Kirki::add_section( $dsn_section, array(
	'panel' => $dsn_panel,
	'title' => esc_html__( 'Menu', 'artit' ),
	'icon'  => 'dashicons-menu-alt3',

) );


Kirki::add_field( $dsn_customize, [
	'type'     => 'radio',
	'settings' => 'menu_type',
	'label'    => esc_html__( "Menu Type", "blackdsn" ),
	'section'  => $dsn_section,
	'default'  => '',
	'priority' => 10,
	'choices'  => [
		''              => esc_html__( "Classic Menu", "blackdsn" ),
		'dsn-hamburger' => esc_html__( "Hamburger Menu", "blackdsn" )
	]

] );


Kirki::add_field( $dsn_customize, [
	'type'      => 'background',
	'settings'  => 'background_setting_menu',
	'label'     => esc_html__( 'Background Menu', 'artit' ),
	'section'   => $dsn_section,
	'default'   => [
		'background-image'      => '',
		'background-repeat'     => 'repeat',
		'background-position'   => 'center center',
		'background-size'       => 'cover',
		'background-attachment' => 'scroll',
	],
	'transport' => 'auto',
	'output'    => [
		[
			'element' => '.dsn-hamburger.site-header  .bg-load.background-main',
		],
	],
] );


Kirki::add_field( $dsn_customize, [
	'type'     => 'toggle',
	'settings' => 'custom_color_menu',
	'label'    => esc_html__( 'Custom Color Menu', 'artit' ),
	'section'  => $dsn_section,
	'default'  => false
] );


Kirki::add_field( $dsn_customize, [
	'type'            => 'color',
	'settings'        => 'color_setting_rgba_menu',
	'label'           => __( 'Color Control (Hamburger Menu)', 'artit' ),
	'section'         => $dsn_section,
	'default'         => '#fff',
	'choices'         => [
		'alpha' => true,
	],
	'transport'       => 'auto',
	'output'          => [
		[
			'element'  => '.dsn-hamburger.site-header .main-navigation ul.primary-nav li a',
			'property' => 'color',
		],
	],
	'active_callback' => [
		[
			'setting'  => 'custom_color_menu',
			'operator' => '==',
			'value'    => true,
		]
	],

] );

Kirki::add_field( $dsn_customize, [
	'type'     => 'color',
	'settings' => 'color_setting_rgba_menu_active',
	'label'    => __( 'Color Control (Active Hamburger Menu)', 'artit' ),
	'section'  => $dsn_section,
	'default'  => get_theme_mod( 'assistant-body-color', '#65bc7b' ),
	'choices'  => [
		'alpha' => true,
	],


	'transport' => 'auto',
	'output'    => [
		[
			'element'  => '.dsn-hamburger.site-header .main-navigation ul.primary-nav li.dsn-active a,.dsn-hamburger.site-header .main-navigation ul.primary-nav li:hover a',
			'property' => 'color',
		],
	],

	'active_callback' => [
		[
			'setting'  => 'custom_color_menu',
			'operator' => '==',
			'value'    => true,
		]
	],
] );


blackdsn_custom_Label( $dsn_section, "Menu Right Description" );
Kirki::add_field( $dsn_customize, [
	'type'      => 'editor',
	'settings'  => 'editor_setting_menu',
	'label'     => esc_html__( 'Description', 'artit' ),
	'section'   => $dsn_section,
	'default'   => '',
	'transport' => 'postMessage',
	'js_vars'   => [
		[
			'element'  => '.site-header .container-content',
			'function' => 'html',
		]
	],

] );


