<?php
Kirki::add_section( $dsn_section, array(
	'panel' => $dsn_panel,
	'title' => esc_html__( 'Logo', 'blackdsn' )

) );
Kirki::add_field( $dsn_customize, [
	'type'     => 'image',
	'settings' => 'custom_logo',
	'label'    => esc_html__( 'Light Logo', 'blackdsn' ),
	'section'  => $dsn_section,
	'default'  => '',
	'choices'  => [
		'save_as' => 'id',
	],
] );


Kirki::add_field( $dsn_customize, [
	'type'     => 'image',
	'settings' => 'custom_logo_dark',
	'label'    => esc_html__( 'Dark Logo', 'blackdsn' ),
	'section'  => $dsn_section,
	'default'  => '',
	'choices'  => [
		'save_as' => 'id',
	],
] );


Kirki::add_field( $dsn_customize, [
	'type'        => 'number',
	'settings'    => 'width_number',
	'label'       => esc_html__( 'Logo Width', 'blackdsn' ),
	'description' => esc_html__( '0 for auto width', 'blackdsn' ),
	'section'     => $dsn_section,
	'default'     => 0,
	'transport'   => "auto",
	'choices'     => [
		'min'  => 0,
		'step' => 10,
	],

	'active_callback' => [
		[
			'setting'  => 'custom_logo',
			'operator' => '!=',
			'value'    => '',
		]
	],
] );


Kirki::add_field( $dsn_customize, [
	'type'        => 'number',
	'settings'    => 'height_number',
	'label'       => esc_html__( 'Logo Height', 'blackdsn' ),
	'description' => esc_html__( '0 for auto Height', 'blackdsn' ),
	'section'     => $dsn_section,
	'default'     => 0,
	'choices'     => [
		'min'  => 0,
		'step' => 10,
	],

	'active_callback' => [
		[
			'setting'  => 'custom_logo',
			'operator' => '!=',
			'value'    => '',
		]
	],
] );

Kirki::add_field( $dsn_customize, [
	'type'            => 'text',
	'settings'        => 'title-logo-page',
	'label'           => esc_html__( 'Title Logo ', 'blackdsn' ),
	'section'         => $dsn_section,
	'default'         => get_bloginfo( 'name' ),
	'transport'       => 'postMessage',
	'active_callback' => [
		[
			'setting'  => 'custom_logo',
			'operator' => '==',
			'value'    => '',
		]
	],
	'js_vars'         => array(
		array(
			'element'  => '.main-logo h4',
			'function' => 'html',
		),
	),
] );


Kirki::add_field( $dsn_customize, [
	'type'     => 'toggle',
	'settings' => 'typography_logo',
	'label'    => esc_html__( 'typography Logo Text', 'blackdsn' ),
	'section'  => $dsn_section,
	'default'  => false,
] );

Kirki::add_field( $dsn_customize, array(
	'type'      => 'typography',
	'settings'  => 'logo_font',
	'section'   => $dsn_section,
	'label'     => esc_html__( 'Logo Font', 'blackdsn' ),
	'transport' => 'auto',

	'choices' => [
		'fonts' => [
			'standard' => [ 'sans-serif' ],
		],
	],

	'default'         => array(
		'font-family' => 'Roboto',
		'font-size'   => '30px',
	),
	'output'          => array(
		array(
			'element' => '.main-logo h4',
		),
	),
	'active_callback' => [
		[
			'setting'  => 'typography_logo',
			'operator' => '==',
			'value'    => '1',
		]
	],

) );

blackdsn_custom_Label( $dsn_section, 'SubText Logo' );


Kirki::add_field( $dsn_customize, [
	'type'      => 'text',
	'settings'  => 'subtitle-logo-page',
	'label'     => esc_html__( 'SubTitle Logo ', 'blackdsn' ),
	'section'   => $dsn_section,
	'default'   => get_bloginfo( 'description', 'display' ),
	'transport' => 'postMessage',

	'js_vars' => array(
		array(
			'element'  => '.main-logo p.site-description',
			'function' => 'html',
		),
	),
] );


Kirki::add_field( $dsn_customize, [
	'type'     => 'toggle',
	'settings' => 'typography_subtitle_logo',
	'label'    => esc_html__( 'typography SubTitle Logo', 'blackdsn' ),
	'section'  => $dsn_section,
	'default'  => false,
] );

Kirki::add_field( $dsn_customize, array(
	'type'      => 'typography',
	'settings'  => 'logo_font',
	'section'   => $dsn_section,
	'label'     => esc_html__( 'Logo Font', 'blackdsn' ),
	'transport' => 'auto',

	'choices' => [
		'fonts' => [
			'standard' => [ 'sans-serif' ],
		],
	],

	'default'         => array(
		'font-family' => 'Roboto',
		'font-size'   => '15px',
	),
	'output'          => array(
		array(
			'element' => '.main-logo .site-description',
		),
	),
	'active_callback' => [
		[
			'setting'  => 'typography_subtitle_logo',
			'operator' => '==',
			'value'    => '1',
		]
	],

) );