<?php
/**
 * Normal Static Setting
 */
Kirki::add_section( $dsn_section, array(
	'panel'       => $dsn_panel,
	'title'       => esc_html__( 'Footer Default', 'blackdsn' ),
	'description' => esc_html__( 'When you create a page, it\'s going to be default.', 'blackdsn' )
) );

Kirki::add_field( $dsn_customize, [
	'type'            => 'radio',
	'settings'        => 'type_footer',
	'label'           => esc_html__( "Type Footer", "blackdsn" ),
	'section'         => $dsn_section,
	'default'         => 'default',
	'priority'        => 10,
	'choices'         => [
		'default' => esc_html__( "Default", "blackdsn" ),
		'custom'  => esc_html__( "Custom", "blackdsn" )
	],
	'transport'       => 'auto',
	'partial_refresh' => [
		'type_footer' => [
			'selector'        => '#dsn_footer',
			'render_callback' => 'default',
		]
	]

] );

new \Kirki\Field\Select( [
	'settings' => 'choose_template_footer',
	'label'    => esc_html__( "Choose Template Footer", "blackdsn" ),
	'section'  => $dsn_section,
	'priority' => 10,
	'choices'  => blackdsn_get_post_array( 'elementor_library' ),

	'active_callback' => [
		[
			'setting'  => 'type_footer',
			'operator' => '==',
			'value'    => 'custom',
		],
	]
] );


new \Kirki\Field\Select(
	[
		'settings' => 'select_posts_css',
		'label'    => esc_html__( "Choose Template Footer", "blackdsn" ),
		'section'  => $dsn_section,
		'default'  => '',
		'priority' => 10,
		'multiple' => true,
		'choices'  => blackdsn_get_post_array( 'elementor_library' ),
	]
);