<?php
Kirki::add_section( $dsn_section, array(
	'panel' => $dsn_panel,
	'title' => esc_html__( 'Cursor Follower', 'blackdsn' ),
	'icon'  => 'dashicons-remove',

) );

Kirki::add_field( $dsn_customize, [
	'type'     => 'toggle',
	'settings' => 'effect_cursor',
	'label'    => esc_html__( 'Effect Cursor', 'blackdsn' ),
	'section'  => $dsn_section,
	'default'  => 0,
] );


$active_callback = [
	[
		'setting'  => 'effect_cursor',
		'operator' => '==',
		'value'    => '1',
	]
];


Kirki::add_field( $dsn_customize, [
	'type'            => 'slider',
	'settings'        => 'cursor_drag_speed',
	'label'           => esc_html__( 'Cursor Drag Speed', 'blackdsn' ),
	'description'     => esc_html__( 'The lower the value is, the faster virtual mouse follower will attract to the native cursor pointer.', 'blackdsn' ),
	'section'         => $dsn_section,
	'default'         => 0.35,
	'choices'         => [
		'min'  => 0.1,
		'max'  => 1,
		'step' => 0.01,
	],
	'active_callback' => $active_callback,
] );

Kirki::add_field( $dsn_customize, [
	'type'            => 'slider',
	'settings'        => 'cursor_drag_speed_inner',
	'label'           => esc_html__( 'Cursor Drag Speed Inner', 'blackdsn' ),
	'description'     => esc_html__( 'The lower the value is, the faster virtual mouse follower will attract to the native cursor pointer.', 'blackdsn' ),
	'section'         => $dsn_section,
	'default'         => 0.15,
	'choices'         => [
		'min'  => 0.1,
		'max'  => 1,
		'step' => 0.01,
	],
	'active_callback' => $active_callback,
] );