<?php

Kirki::add_section( $dsn_section, array(
	'panel' => $dsn_panel,
	'title' => esc_html__( 'Color', 'blackdsn' ),
	'icon'  => 'dashicons-admin-customizer',
) );

$dsn_color = [
	'bg-color'        => [
		'label'   => __( 'background Color Dark', 'blackdsn' ),
		'default' => '#000',
	],
	'assistant-color' => [
		'label'   => __( 'The assistant background Color Dark', 'blackdsn' ),
		'default' => '#101010',
	],
	'heading-color'   => [
		'label'   => __( 'Heading Color Dark', 'blackdsn' ),
		'default' => '#fff',
	],
	'font-color'      => [
		'label'   => __( 'Body Color Dark', 'blackdsn' ),
		'default' => '#bbb',
	],
	'theme-color'     => [
		'label'   => __( 'Theme Color Dark', 'blackdsn' ),
		'default' => '#14bfb5',
	],
	'border-color'    => [
		'label'   => __( 'Border Color Dark', 'blackdsn' ),
		'default' => '#ffffff0a',
	],
];

$dsn_color_light = [
	'bg-color'        => [
		'label'   => __( 'background Color Light', 'blackdsn' ),
		'default' => '#f9f9f9',
	],
	'assistant-color' => [
		'label'   => __( 'The assistant background Color Light', 'blackdsn' ),
		'default' => '#e6e6e6',
	],
	'heading-color'   => [
		'label'   => __( 'Heading Color Light', 'blackdsn' ),
		'default' => '#000',
	],
	'font-color'      => [
		'label'   => __( 'Body Color Light', 'blackdsn' ),
		'default' => '#0009',
	],
	'theme-color'     => [
		'label'   => __( 'Theme Color Light', 'blackdsn' ),
		'default' => '#d90a2c',
	],
	'border-color'    => [
		'label'   => __( 'Border Color Light', 'blackdsn' ),
		'default' => '#bebebe',
	],
];

Kirki::add_field( $dsn_section, [
	'type'     => 'switch',
	'settings' => 'dsn_custom_color',
	'label'    => esc_html__( 'Custom Color Theme', 'blackdsn' ),
	'section'  => $dsn_section,
	'default'  => '',


	'choices' => [
		'on'  => esc_html__( 'Enable', 'blackdsn' ),
		'off' => esc_html__( 'Disable', 'blackdsn' ),
	],
] );

foreach ( $dsn_color as $key => $value ):
	Kirki::add_field( $dsn_section, [
		'type'     => 'color',
		'settings' => $key,
		'label'    => $value['label'],
		'section'  => $dsn_section,
		'default'  => $value['default'],

		'active_callback' => [
			[
				'setting'  => 'dsn_custom_color',
				'operator' => '==',
				'value'    => '1',
			],
		],
	] );
endforeach;

blackdsn_custom_Label( $dsn_section, __( 'Version Light', 'blackdsn' ), '', [
	[
		'setting'  => 'dsn_custom_color',
		'operator' => '==',
		'value'    => '1',
	],
] );


foreach ( $dsn_color_light as $key => $value ):
	Kirki::add_field( $dsn_section, [
		'type'     => 'color',
		'settings' => $key . '-light',
		'label'    => $value['label'],
		'section'  => $dsn_section,
		'default'  => $value['default'],

		'active_callback' => [
			[
				'setting'  => 'dsn_custom_color',
				'operator' => '==',
				'value'    => '1',
			],
		],
	] );
endforeach;


if ( get_theme_mod( 'dsn_custom_color' ) ) {
	add_action( 'wp_head', function () use ( $dsn_color, $dsn_color_light ) { ?>
        <style id="blackdsn_style_color">
             :root .v-light, :root .v-light-head {
            <?php
				foreach ($dsn_color_light as $key => $value):
			printf('--%s:%s;' , $key , get_theme_mod($key. '-light' , $value['default']));
		 endforeach;
			?>

            }

            :root .v-light.background-theme, :root .v-light-head.background-theme,
            :root .v-light .background-theme, :root .v-light-head .background-theme,
            :root .v-light .calendar_wrap table tr td#today, :root .v-light-head .calendar_wrap table tr td#today {
                --heading-color: #fff;
                --font-color: #fff;
                color: var(--font-color);
            }


            :root .v-dark, :root .v-dark-head {
            <?php
				foreach ($dsn_color as $key => $value):

                printf('--%s:%s;' , $key , get_theme_mod($key , $value['default']));
             endforeach;
			?>

            }

            :root .v-dark.background-theme, :root .v-dark-head.background-theme,
            :root .v-dark .background-theme, :root .v-dark-head .background-theme {
                --font-color: #000;
            }

        </style>
	<?php }, 100 );
}