<?php
if ( ! function_exists( 'blackdsn_sanitize_minimal_decoration' ) ) :
	function blackdsn_sanitize_minimal_decoration( $input ) {
		$allowed_html = array(
			'a'      => array(
				'href'            => array(),
				'title'           => array(),
				'class'           => [],
				'data-hover-text' => [],
				'target'          => [],
			),
			'br'     => array(),
			'em'     => array(),
			'strong' => array(),
			'img'    => array(),
			'i'      => array(),
			'p'      => array( 'class' => [] ),
			'span'   => [ 'class' => [] ],

		);

		return wp_kses( $input, $allowed_html );
	}

endif;

$panels = $dsn_panel . "-footer-option";

Kirki::add_panel( $panels, array(
	'title'       => esc_html__( 'Footer Settings', 'blackdsn' ),
	'description' => esc_html__( 'Options Footer Theme', 'blackdsn' ),
	'panel'       => $dsn_panel,
	'icon'        => 'dashicons-tide'
) );


blackdsn_resources_customize( 'option/footer/setting', array(
	'dsn_panel'     => $panels,
	'dsn_customize' => $dsn_customize,
	'dsn_section'   => $dsn_section . '-setting',
) );

/**
 * Feature Dynamic Setting
 */
blackdsn_resources_customize( 'option/footer/js', array(
	'dsn_panel'     => $panels,
	'dsn_customize' => $dsn_customize,
	'dsn_section'   => $dsn_section . '-setting-js',
) );