<?php

class blackdsnStyle {

	const SCROLL = "scroll";
	const COLOR = "color";
	const STYLE = "style";

	public function __construct() {

		add_action( 'init', [ $this, 'initTheme' ] );
		add_filter( 'body_class', [ $this, 'bodyClass' ] );

		add_action( 'wp_ajax_nopriv_blackdsn_style_query', [ $this, 'ajax_style' ] );
		add_action( 'wp_ajax_blackdsn_style_query', [ $this, 'ajax_style' ] );

	}


	/**
	 *
	 */
	public function initTheme() {
		if ( ! session_id() ) {
			session_start();
		}
		$this->getParam();
	}


	/**
	 * @param $classes
	 *
	 * @return mixed
	 */
	public function bodyClass( $classes ) {
		$button_theme = get_theme_mod( 'button_style_theme' );


		if ( $button_theme ) {
			$color     = $this->getColor();
			$classes[] = $color;

			if ( $color !== $this->getStyleDefault() ) {
				$classes[] = 'dsn-change-color';
			}

		} else {
			$classes[] = $this->getStyleDefault();
		}


		if ( ! blackdsn_is_elementor_preview_mode() && blackdsnSession::get( self::SCROLL, get_theme_mod( 'event_smooth_scrolling' ) ) ) {
			$classes[] = 'dsn-effect-scroll';
			wp_enqueue_script( 'smooth-scrollbar' );
		}


		return $classes;
	}


	public function ajax_style() {


		if ( isset( $_POST[ self::COLOR ] ) && isset( $_POST[ self::STYLE ] ) && defined( 'DOING_AJAX' ) && DOING_AJAX ):

			$color = wp_strip_all_tags( $_POST[ self::COLOR ] );
			$style = wp_strip_all_tags( $_POST[ self::STYLE ] );

			if ( $color !== "off" ) {
				blackdsnSession::put( self::COLOR, $color );
			}

			if ( $style !== "off" ) {
				blackdsnSession::put( self::STYLE, $style );
			}


			header( 'Content-Type: application/json' );

			echo json_encode( array(
				'status' => true,
				'color'  => $color,
				'style'  => $style,

			) );

		endif;


		die();
	}


	private function getParam() {
		foreach ( [ self::SCROLL, self::COLOR, self::STYLE ] as $key ):
			if ( isset( $_GET[ $key ] ) ):
				blackdsnSession::put( $key, wp_strip_all_tags( $_GET[ $key ] ) );
			endif;
		endforeach;

	}

	/**
	 * @return false|mixed
	 */
	private function getStyleDefault() {
		if ( is_home() ) {
			return get_theme_mod( 'home_style_setting', 'v-dark' );
		} elseif ( blackdsn_is_product() ) {
			return get_theme_mod( 'product_style_setting', 'v-dark' );
		} elseif ( is_archive() && ! blackdsn_is_shop() ) {
			return get_theme_mod( 'archive_style_setting', 'v-dark' );
		} else {

			$theme_default = get_theme_mod( 'global_style_setting', 'v-dark' );
			if ( ! blackdsn_is_built_with_elementor() || blackdsn_is_elementor_preview_mode() )
				return $theme_default;


			$option_color = blackdsn_doc_elementor()->getVal( 'global_background_color', "auto" );


			return $option_color === 'auto' ? $theme_default : $option_color;
		}
	}

	private function getColor() {
		return blackdsnSession::get( self::COLOR, $this->getStyleDefault() );
	}


	/**
	 * @param false $post_id
	 *
	 * @return false|mixed
	 */
	private function getDefaultStyleCreative() {
		return blackdsn_get_option_pages( 'use_page_as_creative', false, blackdsn_get_id_shop() );
	}

	/**
	 *
	 * @return false|mixed
	 */
	private function getStyleCreative() {
		return blackdsnSession::get( self::STYLE, $this->getDefaultStyleCreative() );
	}


}


new blackdsnStyle();