<?php

class blackdsnSession {

	const THEME_NAME = "blackdsn-";

	/**
	 * @param $name
	 * @param $value
	 *
	 * @return mixed
	 */
	public static function put( $name, $value ) {
		return $_SESSION[ self::THEME_NAME . $name ] = $value;
	}

	/**
	 * @param $name
	 *
	 * @return bool
	 */
	public static function has( $name ) {
		return isset( $_SESSION[ self::THEME_NAME . $name ] );
	}

	/**
	 *
	 * @param  $name
	 * delete session
	 */
	public static function delete( $name ) {
		if ( self::has( $name ) ) {
			unset( $_SESSION[ self::THEME_NAME . $name ] );
		}
	}

	/**
	 * @param $name
	 * @param  $default
	 *
	 * @return mixed
	 */
	public static function get( $name, $default = false ) {

		if ( self::has( $name ) ) {
			return $_SESSION[ self::THEME_NAME . $name ];
		} else {
			return $default;
		}
	}

	public static function flash( $name, $string = '' ) {

		if ( self::has( $name ) ) {
			$session = self::get( $name );
			self::delete( $name );

			return $session;
		} else {
			self::put( $name, $string );
		}
	}

}