<?php

class blackdsnFrontEnd
{

    const FANCYBOX = 'fancybox';
    const SWIPER = 'swiper';
    const FJ_Gallery = 'fjGallery';
    const THREE_JS = 'threejs';
    const ANIMATED_HEADLINE = 'animatedheadline';


    public function __construct()
    {
        add_action('wp_enqueue_scripts', [$this, 'register_script'], 99, 20);
        add_action('elementor/frontend/before_register_scripts', [$this, 'register_script']);
    }


    public function register_script()
    {

        //--> fancybox
        wp_register_style(self::FANCYBOX, BLACKDSN_MODULES_PATH . '/fancybox/fancybox.css', array(), '4.0.26');
        wp_register_script(self::FANCYBOX, BLACKDSN_MODULES_PATH . '/fancybox/fancybox.min.js', array('jquery'), '4.0.26', true);

        //--> Swiper
        wp_register_style(self::SWIPER, BLACKDSN_MODULES_PATH . '/swiper/swiper.min.css', array(), '9.0.5');
        wp_register_script(self::SWIPER, BLACKDSN_MODULES_PATH . '/swiper/swiper.min.js', array('jquery'), '9.0.5', true);

        //--> Flickr's Justified Gallery
        wp_register_style(self::FJ_Gallery, BLACKDSN_MODULES_PATH . '/fjGallery/fjGallery.css', array(), '1.0.7');
        wp_register_script(self::FJ_Gallery, BLACKDSN_MODULES_PATH . '/fjGallery/fjGallery.min.js', array(), '1.0.7', true);

        //--> animate headline
        wp_register_style(self::ANIMATED_HEADLINE, BLACKDSN_MODULES_PATH . '/animatedheadline/jquery.animatedheadline.css');
        wp_register_script(self::ANIMATED_HEADLINE, BLACKDSN_MODULES_PATH . '/animatedheadline/animatedheadline.min.js', array('jquery'), false, true);


        //--> THREE JS
        wp_register_script(self::THREE_JS, BLACKDSN_MODULES_PATH . '/threejs/threejs.min.js', array('jquery'), false, true);


        wp_enqueue_script( self::SWIPER );

    }

}

new blackdsnFrontEnd();