<?php

if ( ! class_exists( "BlackdsnTemplate" ) )
	return;

class blackdsnBootstrapTemplate extends BlackdsnTemplate {

	private static $inst = null;

	public function __construct() {
		parent::__construct();

		do_action( 'blackdsn_template_category', $this->category() );
		do_action( 'blackdsn_template', $this->temp() );
	}

	public static function Instance() {
		if ( self::$inst === null ) {
			self::$inst = new blackdsnBootstrapTemplate();
		}

		return self::$inst;
	}

	protected function enqueue_scripts() {
		//--> fancybox
		wp_enqueue_style( blackdsnFrontEnd::FANCYBOX, BLACKDSN_MODULES_PATH . '/fancybox/fancybox.css', array(), '4.0.26' );
		wp_enqueue_script( blackdsnFrontEnd::FANCYBOX, BLACKDSN_MODULES_PATH . '/fancybox/fancybox.min.js', array( 'jquery' ), '4.0.26', true );
	}

	private function category(): array {

		return [
			'page'        => esc_html__( "Page", 'blackdsn' ),
			'block'       => esc_html__( "Block", 'blackdsn' ),
			'header'      => esc_html__( "Header", 'blackdsn' ),
			'footer'      => esc_html__( "Footer", 'blackdsn' ),
			'photography' => esc_html__( "Photography", 'blackdsn' ),
			'personal'    => esc_html__( "Personal", 'blackdsn' ),
		];
	}

	private function temp(): array {
		$url      = "//templete.dsngrid.com/blackdsn/dsn-template/";
		$url_page = "//dsngrid.com/blackdsn/";

		return [
			'architecture'          => [
				'name'     => esc_html__( "Architecture Page", 'blackdsn' ),
				'category' => [ 'page' ],
				"iframe"   => $url_page . "architecture/"
			],
			'contact_us'            => [
				'name'     => esc_html__( "Contact Us Page", 'blackdsn' ),
				'category' => [ 'page' ],
				"iframe"   => $url . "contact-us/"
			],
			'business'              => [
				'name'     => esc_html__( "Business Page", 'blackdsn' ),
				'category' => [ 'page' ],
				"iframe"   => $url . "demo-2/"
			],
			'demo_3'                => [
				'name'     => esc_html__( "Main Page", 'blackdsn' ),
				'category' => [ 'page' ],
				"iframe"   => $url . "demo-3/"
			],
			'metro_portfolio_1'     => [
				'name'     => esc_html__( "Portfolio Page", 'blackdsn' ),
				'category' => [ 'page' ],
				"iframe"   => $url . "metro-portfolio-1/"
			],
			'personal'              => [
				'name'     => esc_html__( "Personal Page", 'blackdsn' ),
				'category' => [ 'page' ],
				"iframe"   => $url . "personal-2-2/"
			],
			'personal-2'            => [
				'name'     => esc_html__( "Personal Page", 'blackdsn' ),
				'category' => [ 'page' ],
				"iframe"   => $url . "personal-3/"

			],
			'photographer'          => [
				'name'     => esc_html__( "Photographer Page", 'blackdsn' ),
				'category' => [ 'page' ],
				"iframe"   => $url . "photographer-2/"
			],
			'corporate_page'        => [
				'name'     => esc_html__( "Corporate Page", 'blackdsn' ),
				'category' => [ 'page' ],
				"iframe"   => $url . "corporate-page/"
			],
			'creative_page'         => [
				'name'     => esc_html__( "Creative Page", 'blackdsn' ),
				'category' => [ 'page' ],
				"iframe"   => $url . "creative-agance/"
			],
			'footer'                => [
				'name'     => esc_html__( "Footer", 'blackdsn' ),
				'category' => [ 'block', 'footer' ],
				"iframe"   => $url . "footer/"
			],
			'brand'                 => [
				'name'     => esc_html__( "Brand", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "brand/"
			],
			'testimonials'          => [
				'name'     => esc_html__( "Testimonials", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "testimonials/"
			],
			'team'                  => [
				'name'     => esc_html__( "Team", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "team/"
			],
			'service'               => [
				'name'     => esc_html__( "Service", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "service/"
			],
			'about'                 => [
				'name'     => esc_html__( "About", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "about/"
			],
			'header'                => [
				'name'     => esc_html__( "Header", 'blackdsn' ),
				'category' => [ 'block', 'header' ],
				"iframe"   => $url . "header/"
			],
			'about_section_9'       => [
				'name'     => esc_html__( "About Section", 'blackdsn' ),
				'category' => [ 'block', 'personal', 'photography' ],
				"iframe"   => $url . "about-section-9/"
			],
			'about_section_1'       => [
				'name'     => esc_html__( "About Section", 'blackdsn' ),
				'category' => [ 'block', 'personal', 'photography' ],
				"iframe"   => $url . "about-section/"
			],
			'about_section_2'       => [
				'name'     => esc_html__( "About Section", 'blackdsn' ),
				'category' => [ 'block', 'personal', 'photography' ],
				"iframe"   => $url . "about-section-2/"
			],
			'about_section_3'       => [
				'name'     => esc_html__( "About Section", 'blackdsn' ),
				'category' => [ 'block', 'personal', 'photography' ],
				"iframe"   => $url . "about-section-3/"
			],
			'about_section_4'       => [
				'name'     => esc_html__( "About Section", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "about-section-4/"
			],
			'about_section_5'       => [
				'name'     => esc_html__( "About Section", 'blackdsn' ),
				'category' => [ 'block', 'personal', 'photography' ],
				"iframe"   => $url . "about-section-5/"
			],
			'about_section_6'       => [
				'name'     => esc_html__( "About Section", 'blackdsn' ),
				'category' => [ 'block', 'personal', 'photography' ],
				"iframe"   => $url . "about-section-6/"
			],
			'about_section_7'       => [
				'name'     => esc_html__( "About Section", 'blackdsn' ),
				'category' => [ 'block', 'personal', 'photography' ],
				"iframe"   => $url . "about-section-7/"
			],
			'about_section_8'       => [
				'name'     => esc_html__( "About Section", 'blackdsn' ),
				'category' => [ 'block', 'photography' ],
				"iframe"   => $url . "about-section-8/"
			],
			'about_section_10'      => [
				'name'     => esc_html__( "About Section", 'blackdsn' ),
				'category' => [ 'block', 'personal', 'photography' ],
				"iframe"   => $url . "about-section-10/"
			],
			'about_section_11'      => [
				'name'     => esc_html__( "About Section", 'blackdsn' ),
				'category' => [ 'block', 'personal', 'photography' ],
				"iframe"   => $url . "about-section-11/"
			],
			'about_section_12'      => [
				'name'     => esc_html__( "About Section", 'blackdsn' ),
				'category' => [ 'block', 'personal', 'photography' ],
				"iframe"   => $url . "about-section-12/"
			],
			'about_section_13'      => [
				'name'     => esc_html__( "About Section", 'blackdsn' ),
				'category' => [ 'block', 'personal', 'photography' ],
				"iframe"   => $url . "about-section-13/"
			],
			'about_section_14'      => [
				'name'     => esc_html__( "About Section", 'blackdsn' ),
				'category' => [ 'block', 'personal', 'photography' ],
				"iframe"   => $url . "about-section-14/"
			],
			'about_section_15'      => [
				'name'     => esc_html__( "About Section", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "about-section-15/"
			],
			'play_video_2'          => [
				'name'     => esc_html__( "Play Video", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "play-video-2/"
			],
			'play_video'            => [
				'name'     => esc_html__( "Play Video", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "play-video/"
			],
			'portfolio_style_3'     => [
				'name'     => esc_html__( "Portfolio Style", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "portfolio-style-3/"
			],
			'testimonials_1'        => [
				'name'     => esc_html__( "Testimonials", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "testimonials-2/"
			],
			'testimonial_2'         => [
				'name'     => esc_html__( "Testimonials", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "testimonial-2/"
			],
			'skills'                => [
				'name'     => esc_html__( "Skills", 'blackdsn' ),
				'category' => [ 'block', 'personal' ],
				"iframe"   => $url . "skills/"
			],
			'service_style_4'       => [
				'name'     => esc_html__( "Service", 'blackdsn' ),
				'category' => [ 'block', 'personal' ],
				"iframe"   => $url . "service-style-4/"
			],
			'service_style_3'       => [
				'name'     => esc_html__( "Service", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "service-style-3/"
			],
			'service_masonry'       => [
				'name'     => esc_html__( "Service Masonry", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "service-masonry/"
			],
			'service_hover'         => [
				'name'     => esc_html__( "Service Hover", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "service-hover/"
			],
			'service_about'         => [
				'name'     => esc_html__( "Service", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "service-about/"
			],
			'service_2'             => [
				'name'     => esc_html__( "Service", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "service-2/"
			],
			'our_portfolio_style_1' => [
				'name'     => esc_html__( "Portfolio Style", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "our-portfolio-style-12/"
			],
			'map'                   => [
				'name'     => esc_html__( "Map", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "map/"
			],
			'header_video'          => [
				'name'     => esc_html__( "Header Video", 'blackdsn' ),
				'category' => [ 'block', 'header' ],
				"iframe"   => $url . "header-video/"
			],
			'header_4'              => [
				'name'     => esc_html__( "Header", 'blackdsn' ),
				'category' => [ 'block', 'header' ],
				"iframe"   => $url . "header-4/"
			],
			'header_3'              => [
				'name'     => esc_html__( "Header", 'blackdsn' ),
				'category' => [ 'block', 'header' ],
				"iframe"   => $url . "header-3/"
			],
			'header_2'              => [
				'name'     => esc_html__( "Header", 'blackdsn' ),
				'category' => [ 'block', 'header' ],
				"iframe"   => $url . "header-2/"
			],
			'experience'            => [
				'name'     => esc_html__( "Experience", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "experience/"
			],
			'contact_info'          => [
				'name'     => esc_html__( "Contact Info", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "contact-info/"
			],
			'brand_scroll'          => [
				'name'     => esc_html__( "Brand With Scroll", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "brand-scroll/"
			],
			'brand_border'          => [
				'name'     => esc_html__( "Brand Border", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "brand_border/"
			],
			'brand_2'               => [
				'name'     => esc_html__( "Brand", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "brand-2/"
			],
			'blog_style_3'          => [
				'name'     => esc_html__( "Blog Style", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "blog-style-3/"
			],
			'blog_style_2'          => [
				'name'     => esc_html__( "Blog Style", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "blog-style-2/"
			],
			'blog_style_1'          => [
				'name'     => esc_html__( "Blog Style", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "blog-style-1/"
			],
			'aword_2'               => [
				'name'     => esc_html__( "Award", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "aword-2/"
			],
			'aword_1'               => [
				'name'     => esc_html__( "Award", 'blackdsn' ),
				'category' => [ 'block' ],
				"iframe"   => $url . "aword-1/"
			]
		];
	}

	public function print_template_views() {

		blackdsn_view( 'print-template', [
			'categories' => $this->category(),
			'templates'  => $this->temp(),
		], false );
	}

	public function get_json( $name ) {
		return @json_decode( file_get_contents( "https://dsngrid.com/plugins/blackdsn/import/" . $name . ".json" ), true );

	}
}

blackdsnBootstrapTemplate::Instance();
