<?php


class blackdsnAdminPost {

	private $workSlug, $workCatSlug;

	public function __construct() {
		/**
		 * Work
		 */
		$this->workSlug    = blackdsn_project_slug();
		$this->workCatSlug = blackdsn_category_slug();
		add_theme_support( 'post-thumbnails', $this->workSlug );

		add_action( 'init', [ $this, 'adminPost' ] );
		add_action( 'wp_nav_menu_item_custom_fields', [ $this, 'menu_item_text_ajax' ], 10, 2 );
		add_action( 'wp_update_nav_menu_item', [ $this, 'save_menu_item_text_ajax' ], 10, 2 );
		add_action( 'init', [ $this, 'enqueue_post' ] );


	}


	public function adminPost() {
		$this->createWork();
		flush_rewrite_rules();
	}

	private function createWork() {
		register_post_type( $this->workSlug, array(
			'menu_icon'       => BLACKDSN__PLUGIN_DIR_URL . '/assets/img/portfolio.svg',
			'hierarchical'    => true,
			'capability_type' => 'post',
			'supports'        => array( 'title', 'editor', 'author', 'thumbnail', 'revisions', 'excerpt' ),
			'labels'          => array(
				'name'         => esc_html__( 'Works', 'blackdsn' ),
				'new_item'     => esc_html__( 'New Work', 'blackdsn' ),
				'add_new'      => esc_html__( 'Add Work', 'blackdsn' ),
				'add_new_item' => esc_html__( 'Add New Work', 'blackdsn' ),
			),
			'rewrite'         => array( 'slug' => blackdsn_custom_project_slug(), 'with_front' => false ),
			'show_in_rest'    => true,
			'public'          => true,

		) );
		$this->createCategory( $this->workCatSlug, $this->workSlug, blackdsn_custom_category_slug() );
	}


	private function createCategory( string $catSlug, string $postType, string $custSlug ) {


		register_taxonomy( $catSlug, $postType, array(
			'hierarchical' => true,
			'labels'       => array(
				'name'                       => esc_html__( 'Categories', 'blackdsn' ),
				'singular_name'              => esc_html__( 'Categories', 'blackdsn' ),
				'search_items'               => esc_html__( 'Search Categories', 'blackdsn' ),
				'popular_items'              => esc_html__( 'Popular Categories', 'blackdsn' ),
				'all_items'                  => esc_html__( 'All Categories', 'blackdsn' ),
				'parent_item'                => null,
				'parent_item_colon'          => null,
				'edit_item'                  => esc_html__( 'Edit Categories', 'blackdsn' ),
				'update_item'                => esc_html__( 'Update Categories', 'blackdsn' ),
				'add_new_item'               => esc_html__( 'Add New Categories', 'blackdsn' ),
				'new_item_name'              => esc_html__( 'New Categories Name', 'blackdsn' ),
				'separate_items_with_commas' => esc_html__( 'Separate Categories with commas', 'blackdsn' ),
				'add_or_remove_items'        => esc_html__( 'Add or remove Categories', 'blackdsn' ),
				'choose_from_most_used'      => esc_html__( 'Choose from the most used Categories', 'blackdsn' ),
				'not_found'                  => esc_html__( 'No Categories found.', 'blackdsn' ),
				'menu_name'                  => esc_html__( 'Categories', 'blackdsn' ),
			),
			'show_ui'      => true,
			'query_var'    => true,
			'show_in_rest' => true,
			'rewrite'      => array( 'slug' => $custSlug, 'with_front' => false ),
		) );
	}


	function menu_item_text_ajax( $item_id ) {
		$menu_item_desc = get_post_meta( $item_id, '_menu_item_text_ajax', true );
		?>
        <div style="clear: both;padding-top: 10px;margin-bottom: 10px">
            <span class="description" style="margin-bottom: 5px"><?php _e( "Text Ajax", 'blackdsn' ); ?></span><br/>
            <input type="hidden" class="nav-menu-id" value="<?php echo $item_id; ?>"/>
            <div class="logged-input-holder">
                <input type="text" name="menu_item_text_ajax[<?php echo $item_id; ?>]"
                       id="menu-item-desc-<?php echo $item_id; ?>" value="<?php echo esc_attr( $menu_item_desc ); ?>"/>
            </div>
        </div>
		<?php
	}


	function save_menu_item_text_ajax( $menu_id, $menu_item_db_id ) {
		if ( isset( $_POST['menu_item_text_ajax'][ $menu_item_db_id ] ) ) {
			$sanitized_data = sanitize_text_field( $_POST['menu_item_text_ajax'][ $menu_item_db_id ] );
			update_post_meta( $menu_item_db_id, '_menu_item_text_ajax', $sanitized_data );
		} else {
			delete_post_meta( $menu_item_db_id, '_menu_item_text_ajax' );
		}
	}

	public function enqueue_post() {
		$select_posts_css = get_theme_mod( 'select_posts_css', [] );
		if ( ! class_exists( '\Elementor\Plugin' ) && get_theme_mod( 'ajax_pages' ) && is_array( $select_posts_css ) )
			return;

		if ( is_admin() )
			return;


		add_action( 'wp_enqueue_scripts', function () use ( $select_posts_css ) {
			foreach ( $select_posts_css as $id ):
				////			\Elementor\Core\Files\CSS\Post::create( $id )->enqueue();

				$post = \Elementor\Core\Files\CSS\Post::create( $id );
				$name = $post->get_name() . '-' . $post->get_post_id();
//			dd( $post->get_file_name(), $name );
				wp_enqueue_style( $name, $post->get_url() );

			endforeach;
		}, 99 );

	}

}


new blackdsnAdminPost();
