<?php

/**
 *
 *  ============================
 *        Custom Slug Project
 *  ============================
 *
 *  - Retrieves an option value based on an Slug Work name.
 *
 */

/**
 *
 * Enqueue scripts for all admin pages.
 *  Custom CSS , JS For Admin
 */


use Elementor\Element_Base;

add_action( 'admin_enqueue_scripts', function ( $hook ) {
	wp_enqueue_style( 'blackdsn-admin-style', BLACKDSN__PLUGIN_DIR_URL . '/assets/css/style.css' );
}, 20 );


if ( ! function_exists( 'blackdsn_custom_project_slug' ) ) :

	function blackdsn_custom_project_slug() {
		return get_theme_mod( 'blackdsn-project-slug', blackdsn_project_slug() );
	}

endif;

if ( ! function_exists( 'blackdsn_custom_story_slug' ) ) :

	function blackdsn_custom_story_slug() {
		return get_theme_mod( 'blackdsn-story-slug', blackdsn_story_slug() );
	}

endif;


if ( ! function_exists( 'blackdsn_shortcode_render' ) ) :

	function blackdsn_shortcode_render( $target, $att, $content = null, $is_render = true ) {
		return blackdsn_view( 'shortcode/' . $target, array( 'attr' => $att, 'content' => $content ), $is_render );
	}

endif;

if ( ! function_exists( 'blackdsn_shortcode_render_group' ) ) :

	function blackdsn_shortcode_render_group( $target, $att, $content = null, $is_render = true ) {
		return blackdsn_view( 'shortcode/' . $target . '/render', array(
			'attr'    => $att,
			'content' => $content,
		), $is_render );
	}

endif;

if ( ! function_exists( 'blackdsn_shortcode_js_group' ) ) :

	function blackdsn_shortcode_js_group( $target, $att = array(), $content = null, $is_render = true ) {
		return blackdsn_view( 'shortcode/' . $target . '/js', array(
			'attr'    => $att,
			'content' => $content
		), $is_render );
	}

endif;


if ( ! function_exists( 'blackdsn_get_template_render' ) ) :

	function blackdsn_get_template_render( $slug, array $param = array(), $is_render = true ) {

		if ( ! file_exists( plugin_dir_path( __FILE__ ) . '/' . $slug . '.php' ) ) {
			return "";
		}

		if ( count( $param ) ):
			foreach ( $param as $key => $value ):
				set_query_var( $key, $value );
			endforeach;
		endif;

		if ( $is_render ):
			ob_start();
		endif;
		extract( $param );
		include plugin_dir_path( __FILE__ ) . '/' . $slug . '.php';
		if ( $is_render ):
			return ob_get_clean();
		endif;

	}

endif;
if ( ! function_exists( 'blackdsn_resources' ) ) :

	function blackdsn_resources( $slug, array $param = array(), $is_render = false ) {

		blackdsn_get_template_render( 'resources/' . $slug, $param, $is_render );
	}

endif;

if ( ! function_exists( 'blackdsn_resources_block' ) ) :

	function blackdsn_resources_block( $slug, array $param = array(), $is_render = false ) {

		blackdsn_get_template_render( 'resources/views/pages/options/blocks/' . $slug, $param, $is_render );
	}

endif;

if ( ! function_exists( 'blackdsn_templete_part' ) ) :

	function blackdsn_templete_part( $slug, array $param = array(), $is_render = false ) {

		return blackdsn_get_template_render( 'views/template-parts/' . $slug, $param, $is_render );
	}

endif;

if ( ! function_exists( 'blackdsn_view' ) ) :

	function blackdsn_view( $slug, array $param = array(), $is_render = true ) {

		return blackdsn_get_template_render( 'views/' . $slug, $param, $is_render );
	}

endif;

if ( ! function_exists( 'blackdsn_resources_customize' ) ) :

	function blackdsn_resources_customize( $slug, array $param = array(), $is_render = false ) {

		blackdsn_get_template_render( 'resources/views/pages/customizer/block/' . $slug, $param, $is_render );
	}

endif;
/**
 *
 * you can fill in defaults when needed.
 *
 * @param array $pairs The list of supported attributes and their defaults.
 * @param array $att User defined attributes .
 *
 * @return array .
 */
if ( ! function_exists( 'blackdsn_set_attr' ) ) :

	function blackdsn_set_attr( array $pairs, array $att ) {

		foreach ( $att as $key => $value ) {

			if ( ! array_key_exists( $key, $pairs ) ) {

				$pairs[ $key ] = $value;

			}

		}

		return $pairs;
	}

endif;

/**
 *
 * you can fill in defaults when needed.
 *
 * @param array $pairs The list of supported attributes and their defaults.
 * @param array $att User defined attributes .
 *
 * @return string .
 */
if ( ! function_exists( 'blackdsn_get_attr' ) ) :

	function blackdsn_get_attr( $att ) {

		$out = '';

		if ( empty( $att ) ) {

			return $out;

		} elseif ( ! is_array( $att ) ) {

			return $att;

		} elseif ( count( $att ) ) {

			foreach ( $att as $key => $value ) {
				$out .= $key . '="' . $value . '" ';
			}

		}

		return $out;
	}

endif;


/**
 * @return string  - Share Blog in Social media
 */
if ( ! function_exists( 'blackdsn_share_links' ) ) :

	function blackdsn_share_links( $befor = '', $after = '' ) {

		$share_link = get_theme_mod( 'share_link' );
		if ( ! $share_link ) {
			return '';
		}

		$share_links = get_theme_mod( 'show_hide_share_link', array(
			'facebook',
			'twitter',
			'google-plus',
			'pinterest',
		) );

		$url = get_the_permalink();

		$share_buttons = array(
			'facebook'    => blackdsn_set_share_links( esc_html__( 'Facebook', 'blackdsn' ),
				array( 'href' => 'https://www.facebook.com/sharer/sharer.php?u=' . esc_url( $url ) ) ),
			'twitter'     => blackdsn_set_share_links( esc_html__( 'Twitter', 'blackdsn' ),
				array( 'href' => 'https://twitter.com/share?url=' . esc_url( $url ) ) ),
			'google-plus' => blackdsn_set_share_links( esc_html__( 'Google+', 'blackdsn' ),
				array( 'href' => 'https://plus.google.com/share?url=' . esc_url( $url ) ) ),
			'pinterest'   => blackdsn_set_share_links( esc_html__( 'Pinterest', 'blackdsn' ),
				array( 'href' => 'https://www.pinterest.com/pin/create/button/?url=' . esc_url( $url ) ) ),
			'get-pocket'  => blackdsn_set_share_links( esc_html__( 'Get Pocket', 'blackdsn' ),
				array( 'href' => 'https://getpocket.com/save?url=' . esc_url( $url ) ) ),
			'telegram'    => blackdsn_set_share_links( esc_html__( 'Telegram', 'blackdsn' ),
				array( 'href' => 'https://t.me/share/url?url=' . esc_url( $url ) ) ),
		);
		$out           = '';
		foreach ( $share_links as $link ):
			$out .= $befor . $share_buttons[ $link ] . $after;
		endforeach;


		return $out;
	}

endif;

if ( ! function_exists( 'blackdsn_set_share_links' ) ) :

	function blackdsn_set_share_links( $content, $att = array() ) {

		$att = blackdsn_set_attr( $att, array(
			'rel'     => 'nofollow',
			'href'    => '',
			'onclick' => 'window.open(\'' . $att['href'] . '\' , \'share-dialog\', \'width=626,height=436\'); return false;',
		) );

		$att = blackdsn_get_attr( $att );


		return '<a ' . $att . ' >' . $content . '</a>';
	}

endif;


/**
 * Get attachment image HTML.
 *
 * Retrieve the attachment image HTML code.
 *
 * Note that some widgets use the same key for the media control that allows
 * the image selection and for the image size control that allows the user
 * to select the image size, in this case the third parameter should be null
 * or the same as the second parameter. But when the widget uses different
 * keys for the media control and the image size control, when calling this
 * method you should pass the keys.
 *
 * @param array $settings Control settings.
 * @param string $image_size_key Optional. Settings key for image size.
 *                               Default is `image`.
 * @param string $image_key Optional. Settings key for image. Default
 *                               is null. If not defined uses image size key
 *                               as the image key.
 *
 * @return string Image HTML.
 * @since 1.0.0
 * @access public
 * @static
 *
 */


if ( ! function_exists( 'blackdsn_attachment_image_html' ) ) :

	function blackdsn_attachment_image_html( $settings, $image_size_key = 'image', $image_key = null, $class = '' ) {

		if ( ! class_exists( 'Elementor\Control_Media' ) ) {
			return '';
		}
		if ( ! class_exists( 'Elementor\Group_Control_Image_Size' ) ) {
			return '';
		}
		if ( ! function_exists( 'get_intermediate_image_sizes' ) ) {
			return '';
		}

		if ( ! $image_key ) {
			$image_key = $image_size_key;
		}

		$image = $settings[ $image_key ];

		// Old version of image settings.
		if ( ! isset( $settings[ $image_size_key . '_size' ] ) ) {
			$settings[ $image_size_key . '_size' ] = '';
		}

		$size = $settings[ $image_size_key . '_size' ];

		$image_class = ! empty( $settings['hover_animation'] ) ? 'elementor-animation-' . $settings['hover_animation'] : '';

		$html = '';

		// If is the new version - with image size.
		$image_sizes = get_intermediate_image_sizes();

		$image_sizes[] = 'full';

		if ( ! empty( $image['id'] ) && ! wp_attachment_is_image( $image['id'] ) ) {
			$image['id'] = '';
		}

		if ( ! empty( $image['id'] ) && in_array( $size, $image_sizes ) ) {
			$image_class .= " attachment-$size size-$size " . blackdsn_get_option_array( $settings,
					'animate_image_style', 'has-top-bottom' );
			$image_attr  = [
				'class'             => trim( $image_class ) . ' ' . trim( $class ),
				'data-dsn-position' => esc_attr( blackdsn_position_image_settings( $settings ) ),

			];

			$html .= wp_get_attachment_image( $image['id'], $size, false, $image_attr );
		}

//        else {
//
//            $image_src = \Elementor\Group_Control_Image_Size::get_attachment_image_src( $image[ 'id' ], $image_size_key, $settings );
//
//            if ( !$image_src && isset( $image[ 'url' ] ) ) {
//                $image_src = $image[ 'url' ];
//            }
//
//            if ( !empty( $image_src ) ) {
//                $image_class_html = !empty( $image_class ) ? ' class="' . $image_class . '"' : '';
//
//                $html .= sprintf( '<img src="%s" title="%s" alt="%s"%s />', esc_attr( $image_src ), \Elementor\Control_Media::get_image_title( $image ), \Elementor\Control_Media::get_image_alt( $image ), $image_class_html );
//            }
//        }

		/**
		 * Get Attachment Image HTML
		 *
		 * Filters the Attachment Image HTML
		 *
		 * @param string $html the attachment image HTML string
		 * @param array $settings Control settings.
		 * @param string $image_size_key Optional. Settings key for image size.
		 *                               Default is `image`.
		 * @param string $image_key Optional. Settings key for image. Default
		 *                               is null. If not defined uses image size key
		 *                               as the image key.
		 *
		 * @since 2.4.0
		 */
		return apply_filters( 'elementor/image_size/get_attachment_image_html', $html, $settings, $image_size_key,
			$image_key );
	}
endif;

/**
 * Get the caption for current widget.
 *
 * @access private
 *
 * @param $settings
 *
 * @return string
 * @since 2.3.0
 */
if ( ! function_exists( 'blackdsn_get_caption' ) ) :

	function blackdsn_get_caption( $settings ) {
		if ( ! isset( $settings['image'] ) ) {
			return '';
		}

		$caption = '';
		if ( ! class_exists( 'Elementor\Utils' ) ) {
			return $caption;
		}
		if ( ! empty( $settings['caption_source'] ) ) {
			switch ( $settings['caption_source'] ) {
				case 'attachment':
					$caption = wp_get_attachment_caption( $settings['image']['id'] );
					break;
				case 'custom':
					$caption = ! \Elementor\Utils::is_empty( $settings['caption'] ) ? $settings['caption'] : '';
			}
		}

		return $caption;
	}
endif;


if ( ! function_exists( 'blackdsn_get_space' ) ) :

	function blackdsn_get_space( $settings ) {
		$out = '';
		if ( blackdsn_get_option_array( $settings, 'use_space_top' ) ) {
			$out .= 'mt-30';
		}
		if ( blackdsn_get_option_array( $settings, 'use_space_bottom' ) ) {
			$out .= ' mb-30';
		}

		return $out;
	}
endif;

if ( ! function_exists( 'blackdsn_parse_text_editor' ) ) :

	function blackdsn_parse_text_editor( $content, $settings ) {
		/** This filter is documented in wp-includes/widgets/class-wp-widget-text.php */
		$content = apply_filters( 'widget_text', $content, $settings );

		$content = shortcode_unautop( $content );
		$content = do_shortcode( $content );
		$content = wptexturize( $content );

		if ( $GLOBALS['wp_embed'] instanceof \WP_Embed ) {
			$content = $GLOBALS['wp_embed']->autoembed( $content );
		}

		return $content;
	}
endif;

if ( ! function_exists( 'blackdsn_excerpt' ) ) :

	function blackdsn_excerpt( $limit, $post = null, $content = null ) {
		if ( $content != null ) {
			$excerpt = explode( ' ', $content, $limit );
		} else {
			$excerpt = explode( ' ', get_the_excerpt( $post ), $limit );
		}

		if ( count( $excerpt ) >= $limit ) {
			array_pop( $excerpt );
			$excerpt = implode( " ", $excerpt );
		} else {
			$excerpt = implode( " ", $excerpt );
		}

		$excerpt = preg_replace( '`\[[^\]]*\]`', '', $excerpt );

		return $excerpt;
	}
endif;


if ( ! function_exists( 'blackdsn_custom_category_slug' ) ) :

	function blackdsn_custom_category_slug() {
		$cat = get_theme_mod( 'blackdsn-category-slug', blackdsn_category_slug() );
		if ( $cat === 'category' ) {
			return 'categories';
		} else {
			return get_theme_mod( 'blackdsn-category-slug', blackdsn_category_slug() );
		}
	}

endif;

if ( ! function_exists( 'blackdsn_custom_category_story_slug' ) ) :

	function blackdsn_custom_category_story_slug() {
		$cat = get_theme_mod( 'blackdsn-category_story-slug', blackdsn_category_story_slug() );
		if ( $cat === 'category' ) {
			return 'categories';
		} else {
			return $cat;
		}
	}

endif;

if ( ! function_exists( 'blackdsn_default_social' ) ) :

	function blackdsn_default_social() {
		return [
			[
				'name'           => esc_html__( 'Facebook.', 'blackdsn' ),
				'init_name'      => esc_html__( 'Fb', 'blackdsn' ),
				'icon'           => 'fab fa-facebook-f',
				'link'           => esc_html__( '#0', 'blackdsn' ),
				'show_in_header' => 1,
				'show_in_footer' => 1,
			],
			[
				'name'           => esc_html__( 'Instagram.', 'blackdsn' ),
				'init_name'      => esc_html__( 'Instagram', 'blackdsn' ),
				'icon'           => 'fab fa-instagram',
				'link'           => esc_html__( '#0', 'blackdsn' ),
				'show_in_header' => 1,
				'show_in_footer' => 1,
			],
			[
				'name'           => esc_html__( 'Twitter.', 'blackdsn' ),
				'init_name'      => esc_html__( 'Tw', 'blackdsn' ),
				'icon'           => 'fab fa-twitter',
				'link'           => esc_html__( '#0', 'blackdsn' ),
				'show_in_header' => 1,
				'show_in_footer' => 1,
			],
			[
				'name'           => esc_html__( 'Linkedin.', 'blackdsn' ),
				'init_name'      => esc_html__( 'Linkedin', 'blackdsn' ),
				'icon'           => 'fab fa-linkedin-in',
				'link'           => esc_html__( '#0', 'blackdsn' ),
				'show_in_header' => 1,
				'show_in_footer' => 1,
			],

		];
	}

endif;


if ( ! function_exists( 'blackdsn_default_info_header' ) ) :

	function blackdsn_default_info_header() {
		return array(
			array( 'title' => 'Service', 'content' => 'blackdsn' ),
			array( 'title' => 'Industry', 'content' => 'dsnGrid' ),
			array( 'title' => 'Year', 'content' => 'May 27th 2020' )
		);
	}

endif;


if ( ! function_exists( 'blackdsn_get_filter_categories' ) ) :

	/**
	 * @return array
	 */
	function blackdsn_get_filter_categories( WP_Query $myposts, $category = 'category' ) {
		$terms = array();
		foreach ( $myposts->posts as $mypost ):
			if ( $categories = get_the_terms( $mypost->ID, $category ) ) {
				foreach ( $categories as $cat ):
					$terms[ $cat->slug ] = $cat->name;
				endforeach;
			}
		endforeach;

		return $terms;
	}

endif;

add_action( 'blackdsn_social', function ( $args ) {
	echo blackdsn_shortcode_render( 'widget/social-' . $args['type'], $args );
} );


if ( ! function_exists( 'blackdsn_compare_get_img' ) ) :


	function blackdsn_compare_get_img( $target, $shortcode, $widget ) {

		$color_overlay = $shortcode->getVal( 'color_overlay_' . $target );
		if ( $color_overlay ) {
			$widget->add_render_attribute( 'img_' . $target, 'style', '--bg-overlay:' . $color_overlay . ';' );
		}

		$widget->add_render_attribute( 'img_' . $target, 'data-overlay',
			$shortcode->getValueNumberSlide( 'opacity_overlay_' . $target, 0 ) );
		$widget->add_render_attribute( 'img_' . $target, 'class', [ 'img-comp-img', 'img-comp-' . $target ] );
		if ( $target === 'before' ) {
			$widget->add_render_attribute( 'img_' . $target, 'class', 'img-comp-overlay' );
		}

		$img  = $shortcode->getVal( 'image_' . $target );
		$size = $shortcode->getVal( 'image_' . $target . '_size' );


		return $shortcode->getAttachImage( $img, $size, [
				'class'             => 'cover-bg-img',
				'data-dsn-position' => $shortcode->getVal( 'position_image_position_x' . $target,
						50 ) . '% ' . $shortcode->getVal( 'position_image_position_y' . $target, 50 ) . '%',
			]
		);

	}
endif;

if ( ! function_exists( 'blackdsn_get_post_array' ) ) :
	function blackdsn_get_post_array( $post_type = null, $args = [] ) {


		$out     = [];
		$myPosts = get_posts( array_merge(
			[ "post_type" => $post_type, 'posts_per_page' => - 1 ],
			$args
		) );

		if ( $myPosts ) {
			foreach ( $myPosts as $post ) :
				$out[ $post->ID ] = $post->post_title;
			endforeach;
		}

		return $out;

	}
endif;
if ( ! function_exists( 'blackdsn_get_currency_symbol' ) ) :

	function blackdsn_get_currency_symbol( $symbol_name ) {
		$symbols = [
			'dollar'       => '&#36;',
			'euro'         => '&#128;',
			'franc'        => '&#8355;',
			'pound'        => '&#163;',
			'ruble'        => '&#8381;',
			'shekel'       => '&#8362;',
			'baht'         => '&#3647;',
			'yen'          => '&#165;',
			'won'          => '&#8361;',
			'guilder'      => '&fnof;',
			'peso'         => '&#8369;',
			'peseta'       => '&#8359',
			'lira'         => '&#8356;',
			'rupee'        => '&#8360;',
			'indian_rupee' => '&#8377;',
			'real'         => 'R$',
			'krona'        => 'kr',
		];

		return isset( $symbols[ $symbol_name ] ) ? $symbols[ $symbol_name ] : '';
	}
endif;

if ( ! function_exists( 'blackdsn_render_widget_motion_effect' ) ) :

	function blackdsn_render_widget_motion_effect( Element_Base $element, string $string = '_wrapper' ) {


		if ( $string !== '_wrapper' && ! is_admin() )
			return;


		$shortcode = new blackdsnShortCode( [ 'widget-base' => $element ] );


		if ( ! $shortcode->getVal( 'use_motion_effect' ) )
			return;

		$animation = [
			'from'       => [],
			'to'         => [],
			'option'     => [
				'scrub'   => $shortcode->getVal( 'use_scrub' ),
				'pin'     => boolval( $shortcode->getVal( 'use_pin' ) ),
				'markers' => boolval( $shortcode->getVal( 'use_markers' ) ),
				'start'   => $shortcode->getVal( 'use_start', '100%' ),
				'end'     => $shortcode->getVal( 'use_end', '0%' ),
				'trigger' => $shortcode->getVal( 'use_trigger' )
			],
			'responsive' => $shortcode->getVal( 'dsn_animation_layout', [ 'desktop', 'tablet', 'mobile' ] )

		];

		foreach ( [ 'from', 'to' ] as $type ):
			foreach ( $shortcode->getVal( 'items_' . $type ) as $item ):
				$key = $item['key'] === 'custom' ? $item['custom'] : $item['key'];

				if ( $key ):
					$animation[ $type ][ $key ] = $item['value'];
					if ( isset( $item['value_tablet'] ) && $item['value_tablet'] != null )
						$animation[ $type . '_tablet' ][ $key ] = $item['value_tablet'];
					if ( isset( $item['value_mobile'] ) && $item['value_mobile'] != null )
						$animation[ $type . '_mobile' ][ $key ] = $item['value_mobile'];

				endif;

			endforeach;
		endforeach;

		$element->add_render_attribute( $string, 'data-dsn-animation', json_encode( $animation ) );

	}
endif;