<?php

/**
 * Plugin Name: BlackDSN Functionality Plugins
 * Plugin URI: https://themeforest.net/user/design_grid
 * Description: Core Plugin for Blackdsn WordPress Theme
 * Version: 1.2.3
 * Author URI: https://themeforest.net/user/design_grid
 * Text Domain: blackdsn
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

define( 'BLACKDSN__PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
define( 'BLACKDSN__PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'BLACKDSN__PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );
define( 'BLACKDSN_MODULES_PATH', plugin_dir_url( __FILE__ ) . '/modules' );


class BlackdsnHelperPlugin {


	public function __construct() {


		$this->include_helper_files();

	}

	public function include_files( $files, $suffix = '' ) {
		foreach ( $files as $file ) {
			$filepath = BLACKDSN__PLUGIN_DIR . $suffix . $file . '.php';
			if ( ! file_exists( $filepath ) ) :
				trigger_error( sprintf( esc_html__( 'Error locating %s for inclusion', 'blackdsn' ), $file ),
					E_USER_ERROR );
			endif;
			require_once $filepath;
		}
		unset( $file, $filepath );
	}

	public function include_helper_files() {

		$files = array(
			'blackdsnFrontEnd',
			'blackdsnBootstrapTemplate',
			'blackdsnSvg',
			'blackdsn-function-helper',
			'blackdsn-function-widget',
			'blackdsnAdminPost',
			'views/shortcode/blackdsnShortCode',
			'blackdsnSession',
			'blackdsnStyle',


			'resources/views/pages/options/inc/notices',


			'resources/views/pages/options/widgets/control/BlackdsnRenderSectionElement',
			'resources/views/pages/options/widgets/control/BlackdsnRegisterElement',
			'resources/views/pages/options/widgets/control/Blackdsn_Widget_Base',
			'resources/views/pages/options/widgets/control/BlackdsnSwiper',
		);
		$this->include_files( $files, 'inc/' );


	}


}


function blackdsnDev(): BlackdsnHelperPlugin {

	if ( defined( 'BLACKDSN_DIRECTORY' ) && file_exists( BLACKDSN_DIRECTORY . '/inc/classes/BlackdsnTemplate.php' ) )
		require_once BLACKDSN_DIRECTORY . '/inc/classes/BlackdsnTemplate.php';


	return new BlackdsnHelperPlugin();
}

add_action( 'blackdsn_developer', function ( $array = array() ) {

	blackdsnDev();

	foreach ( $array as $value ):
		blackdsn_resources( $value );
	endforeach;
} );
